#if !defined(CHESSUI_HPP)
#define CHESSUI_HPP

#include "misc.hpp"
#include "chess.hpp"

// highest layer of user interface
class CHESSUSERIFACE
  {
  public:
    // tell user heap memory exhausted
    CLASSMEMBER void outOfMemory(void);
    // initialize user interface, with board in given configuration
    CLASSMEMBER void init(const BOARD &board);
    // tell user the king of the given color is in checkmate
    CLASSMEMBER void mated(PIECECOLOR color);
    // tell user the king of the given color is in stalemate
    CLASSMEMBER void staleMated(PIECECOLOR color);
    // ask user how to move a piece of the given color on the board.
    // display the move and also invoke the doUserMove member function
    // of board for the move.
    CLASSMEMBER BOOL userMove(BOARD &board, PIECECOLOR color);
    // tell the user the player of the given color is thinking about
    // their next move
    CLASSMEMBER void thinkingMessage(PIECECOLOR color);
    // clear the last Message
    CLASSMEMBER void clearMessage(void);
    // display a move that has been selected by the computer.
    // also invokes the doMove member of board for the move.
    CLASSMEMBER BOOL computerMove
      (
	BOARD &board,
	PIECECOLOR color,
	PIECEMOVE &moveInfo
      );
  };

// only instance of this class
extern CHESSUSERIFACE ChessUI;

#endif
